import 'dart:async';
import 'package:absenkuv3/Bloc/Absensi/AbsensiBloc.dart';
import 'package:absenkuv3/Bloc/AuthBloc.dart';
import 'package:absenkuv3/Bloc/NavigatorBloc.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mAbsensiPage.dart';
import 'package:absenkuv3/Repository/Model/mAbsensi.dart';
import 'package:absenkuv3/Repository/Model/mLogin.dart';
import 'package:absenkuv3/Setting/PengaturanBahasa.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Modul/Absensi/KomponenAbsensi.dart';
import 'package:absenkuv3/UI/Template/Camera/Model/CameraModel.dart';
import 'package:absenkuv3/UI/Template/CameraX/Bloc/FaceXBloc.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:absenkuv3/UI/Template/templateIconInformation.dart';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:geolocator/geolocator.dart';
import 'package:google_maps_flutter/google_maps_flutter.dart';

class HalamanAbsensi extends StatefulWidget {
  const HalamanAbsensi({super.key});

  @override
  State<HalamanAbsensi> createState() => _HalamanAbsensiState();
}


class _HalamanAbsensiState extends State<HalamanAbsensi>
    with WidgetsBindingObserver {
  GlobalKey<ScaffoldState> scaffoldKey = GlobalKey();
  CameraModel? cameraModel;
  TextEditingController keterangan = TextEditingController();
  late AbsensiHariIniRespon absensiHariIniRespon;
  DataAbsensi? dataHariIni;
  Lokasi? lokasi;
  JadwalAbsensi? jadwalAbsensi;
  StatusButtonAbsensi? statusButtonAbsensi;
  String? jamMasuk;
  String? jamPulang;
  String? jamKerja;
  String? jenisPeringatan;
  String? messagePeringatan;
  bool lifeCycleStateInit = true;
  bool? fleksible_jam_kerja;

  static const MethodChannel methodChannel = MethodChannel('absenku/camerax');
  static const EventChannel eventChannel = EventChannel('absenku/camerax/report');

  String _reportStatus = ' {"foto":"","matrix":""}';
  String? foto = "";
  String? matrix = "";
  var registrasi = false;
  String? jenis;
  Position? position;
  String? kamera2;

  StreamSubscription<Position>? _positionStream;
  Position? currentPosition;
  double? currentAccuracy;

  Completer<GoogleMapController> _controller = Completer();

  @override
  void initState() {
    WidgetsBinding.instance.addObserver(this);
    BlocProvider.of<AbsensiBloc>(context).add(CekAbsenEvent(context));
    BlocProvider.of<FaceXBloc>(context).add(InitialDialog(context));
    _startLocationUpdates();
    super.initState();
  }

  void _startLocationUpdates() {
    LocationSettings locationSettings = const LocationSettings(
      accuracy: LocationAccuracy.best,
      distanceFilter: 5,
    );

    _positionStream = Geolocator.getPositionStream(locationSettings: locationSettings)
        .listen((Position position) {
      setState(() {
        currentPosition = position;
        currentAccuracy = position.accuracy;
      });

      animateCamera(_controller, position); // optionally move camera
    });
  }

  void didChangeAppLifecycleState(AppLifecycleState state) async {
    if (state == AppLifecycleState.resumed && lifeCycleStateInit) {
      BlocProvider.of<AbsensiBloc>(context).add(CekAbsenEvent(context));
    }
  }

  @override
  Widget build(BuildContext context) {
    return WillPopScope(
      onWillPop: keluar,
      child: Scaffold(
        key: scaffoldKey,
        backgroundColor: CustomStyle.backgroundDashboardColor,
        body: BlocBuilder<AuthBloc, LoginRespon>(
            builder: (BuildContext context, LoginRespon loginRespon) {
          return BlocListener<AbsensiBloc, AbsensiState>(
            listener: (BuildContext context, AbsensiState state) {
              if (state is PeringatanState) {}
            },
            child: FutureBuilder<PageAbsensiModel>(
                future: PengaturanBahasa().absensi(),
                builder: (context, snapshot) {
                  if (snapshot.connectionState == ConnectionState.done) {
                    return BlocListener<AbsensiBloc, AbsensiState>(
                      listener: (BuildContext context, AbsensiState state) {
                        if (state is PeringatanState) {}
                      },
                      child: BlocBuilder<AbsensiBloc, AbsensiState>(
                        builder: (context, state) {
                          Set<Marker> _markers = {};
                          CameraPosition _initPosition =
                              CameraPosition(target: LatLng(-6.9932, 110.4203));
                          if (state is AbsensiLoading) {
                            return Center(
                              child: CircularProgressIndicator(strokeWidth: 8),
                            );
                          } else if (state is AbsensiFailure) {
                            return Center(
                              child: Text(state.errorMessage),
                            );
                          } else if (state is AbsensiSuccess) {
                            animateCamera(_controller, state.position!);
                            _markers = state.markers;
                            absensiHariIniRespon = state.dataAbsen;
                            dataHariIni = absensiHariIniRespon.data!.dataAbsensi;
                            lokasi = absensiHariIniRespon.data!.lokasi;
                            jadwalAbsensi = absensiHariIniRespon.data!.jadwalAbsensi;
                            statusButtonAbsensi = absensiHariIniRespon.data!.statusButtonAbsensi;
                            fleksible_jam_kerja = absensiHariIniRespon.data!.fleksible_jam_kerja;

                            jamMasuk = jadwalAbsensi!.jamKerja != null
                                ? jadwalAbsensi!.jamKerja!.jamMasuk
                                : '';
                            jamPulang = jadwalAbsensi!.jamKerja != null
                                ? jadwalAbsensi!.jamKerja!.jamPulang
                                : '';
                            jamKerja = '$jamMasuk - $jamPulang';

                            return Stack(
                              children: [
                                GoogleMap(
                                  myLocationButtonEnabled: true,
                                  compassEnabled: true,
                                  zoomControlsEnabled: false,
                                  initialCameraPosition: _initPosition,
                                  mapType: MapType.normal,
                                  onMapCreated: (GoogleMapController controllers) {
                                    _controller.complete(controllers);
                                  },
                                  markers: _markers,
                                ),
                                Align(
                                  alignment: Alignment.topCenter,
                                  child: Padding(
                                    padding: const EdgeInsets.fromLTRB(20, 40, 20, 0),
                                    child: Row(
                                      mainAxisAlignment: MainAxisAlignment.spaceBetween,
                                      children: [
                                        TombolIcon(
                                          icon: Icons.keyboard_arrow_left,
                                          onClick: () => BlocProvider.of<NavigatorBloc>(context)
                                              .add(NavigateRemoveToDashboard(context)),
                                        ),
                                        TombolIcon(
                                          icon: Icons.refresh,
                                          onClick: () => BlocProvider.of<AbsensiBloc>(context)
                                              .add(CekAbsenEvent(context)),
                                        ),
                                      ],
                                    ),
                                  ),
                                ),
                                Align(
                                  alignment: Alignment.bottomCenter,
                                  child: Padding(
                                    padding: EdgeInsets.symmetric(horizontal: 12),
                                    child: Column(
                                      mainAxisAlignment: MainAxisAlignment.end,
                                      children: [
                                        Container(
                                          width: double.infinity,
                                          decoration: CustomStyle.boxDecoration,
                                          child: Padding(
                                            padding: const EdgeInsets.symmetric(horizontal: 0, vertical: 8),
                                            child: Column(
                                              children: [
                                                IconInformation(
                                                  icon: ValueImage.iconLokasi,
                                                  title: snapshot.data!.absensi!.data!.lokasi,
                                                  subtitle: lokasi!.ketLokasi ?? '',
                                                  sizeIcon: 33,
                                                  content: !lokasi!.bolehAbsen!
                                                      ? snapshot.data!.absensi!.messagePeringatan!.tidakBolehAbsen
                                                      : null,
                                                  contentColor: Colors.redAccent,
                                                ),
                                                Divider(),
                                                IconInformation(
                                                  icon: ValueImage.iconRadius,
                                                  title: snapshot.data!.absensi!.data!.akurasi,
                                                  subtitle:
                                                      '${(currentAccuracy ?? state.position!.accuracy).round()} ${snapshot.data!.absensi!.data!.meter}',
                                                  sizeIcon: 29,
                                                ),
                                              ],
                                            ),
                                          ),
                                        ),
                                      ],
                                    ),
                                  ),
                                )
                              ],
                            );
                          } else {
                            return Container();
                          }
                        },
                      ),
                    );
                  } else {
                    return Container();
                  }
                }),
          );
        }),
      ),
    );
  }

  @override
  void dispose() {
    WidgetsBinding.instance.removeObserver(this);
    _positionStream?.cancel(); // Hentikan listener
    super.dispose();
  }

  Future<bool> keluar() async {
    BlocProvider.of<NavigatorBloc>(context).add(NavigateRemoveToDashboard(context));
    BlocProvider.of<AbsensiBloc>(context).add(LoadingEvent(context));
    return false;
  }

  Future<void> animateCamera(
      Completer<GoogleMapController> _controller, Position currentLocation) async {
    final GoogleMapController controller = await _controller.future;
    CameraPosition _current = CameraPosition(
        target: LatLng(currentLocation.latitude, currentLocation.longitude), zoom: 17);
    controller.animateCamera(CameraUpdate.newCameraPosition(_current));
  }
}
